clear

figure('Position', [200 80 1000 198])

t = tiledlayout(1,5);
t.TileSpacing = 'none';
t.Padding = 'none';
ylabel(t, {'';'';'';''}, 'FontWeight', 'Bold', 'FontSize', 15)

phi = 0:5:20;
ExPortH = 0.075:0.0125:0.225;
InPortH = 0.05:0.0125:0.2;

a = 41.6625;
l = 166.65;
B = 75.75;
theta = -180:0.01:180;

IntakePistonPosition = zeros(1, length(theta));
ExhaustPistonPosition = zeros(1, length(theta));
CylinderVolume = zeros(1, length(theta));

ClearanceVolume = zeros(length(phi),1);
GeometricCompressionRatio = zeros(length(phi),1);

IPO = zeros(length(InPortH),length(ExPortH),length(phi));
IPC = zeros(length(InPortH),length(ExPortH),length(phi));
EPO = zeros(length(InPortH),length(ExPortH),length(phi));
EPC = zeros(length(InPortH),length(ExPortH),length(phi));
FPO = zeros(length(InPortH),length(ExPortH),length(phi));
LPC = zeros(length(InPortH),length(ExPortH),length(phi));

TrappedExpansionRatio = zeros(length(InPortH),length(ExPortH),length(phi));
TrappedCompressionRatio = zeros(length(InPortH),length(ExPortH),length(phi));
ExpansionCompressionRatio = zeros(length(InPortH),length(ExPortH),length(phi));


for k = 1:length(phi)
    
    for x = 1:length(theta)
        IntakePistonPosition(x) = (a - l + a*cos((theta(x)-(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta(x)-(phi(k)/2))*pi/180).^2))/(2*a);
        ExhaustPistonPosition(x) = (a - l + a*cos((theta(x)+(phi(k)/2))*pi/180) + sqrt(l^2 - a^2*sin((theta(x)+(phi(k)/2))*pi/180).^2))/(2*a);
        CylinderVolume(x) = ((2*a * (2 - IntakePistonPosition(x) - ExhaustPistonPosition(x))) + 11.6551) * pi()/4 * B^2;
    end
    
    ClearanceVolume(k) = min(CylinderVolume);
    GeometricCompressionRatio(k) = max(CylinderVolume) / min(CylinderVolume);
    
    for j = 1:length(ExPortH)
        for i = 1:length(InPortH)
            
            IPO(i,j,k) = find(IntakePistonPosition>InPortH(i),1, 'last');
            IPC(i,j,k) = find(IntakePistonPosition>InPortH(i),1);
            
            EPO(i,j,k) = find(ExhaustPistonPosition>ExPortH(j),1, 'last');
            EPC(i,j,k) = find(ExhaustPistonPosition>ExPortH(j),1);

            FPO(i,j,k) = min(IPO(i,j,k),EPO(i,j,k));
            LPC(i,j,k) = max(IPC(i,j,k),EPC(i,j,k));
            
            TrappedExpansionRatio(i,j,k) = CylinderVolume(FPO(i,j,k)) / ClearanceVolume(k);
            TrappedCompressionRatio(i,j,k) = CylinderVolume(LPC(i,j,k)) / ClearanceVolume(k);
            
            ExpansionCompressionRatio(i,j,k) = TrappedExpansionRatio(i,j,k) / TrappedCompressionRatio(i,j,k);
            
        end
    end
    
    c = flipud(jet(1000));
    
    nexttile(k)
    contourf(ExPortH,InPortH,ExpansionCompressionRatio(:,:,k), (0.8:0.05:1.2), 'ShowText', 'on', 'LineColor', [0.2 0.2 0.2]);
    colormap(gca, c(250:750,:))
    caxis([0.8 1.2])
    str = num2str(phi(k));
%     title({str;''}, 'FontWeight', 'bold', 'FontSize', 12)
    set(gca, 'FontSize', 10)
    xticks(0:0.05:0.3)
    xtickformat('%.2f')
    

    if k == 1
        yticks(0:0.05:0.3)
        ytickformat('%.2f')
        ylabel('  ', 'FontSize', 10)
    elseif k == 3
        set(gca,'Yticklabel',[])
        xlabel('Exhaust Port Height Ratio', 'FontSize', 10)
    else
        set(gca,'Yticklabel',[])
    end
    
    axis('square')
    
%     nexttile(length(phi) + k)
%     contourf(ExPortH,InPortH,TrappedCompressionRatio(:,:,k), (8:0.5:20), 'ShowText', 'on');
%     colormap(gca, c(250:750,:))
%     caxis([9 14])
%     set(gca,'Xticklabel',[])
%     xticks(0:0.05:0.3)
%     xtickformat('%.2f')
%     set(gca, 'FontSize', 10)
    
%     if k == 1
%         yticks(0:0.05:0.3)
%         ytickformat('%.2f')
%         ylabel('Intake Port Height Ratio', 'FontSize', 10)
%     elseif k == 3
%         set(gca,'Yticklabel',[])
% %         xlabel('Exhaust Port Height Ratio', 'FontSize', 10)
%     else
%         set(gca,'Yticklabel',[])
%     end
% 
%     axis('square')
    
end

cb = colorbar;
cb.Layout.Tile = 'east';
cb.Ticks = 0.8:0.1:1.2;
cb.Ruler.TickLabelFormat = '%.1f';
cb.FontSize = 10;

annotation('textbox', [0.0, 0.76, 0, 0], 'string', 'Expansion Compression Ratio', 'FontWeight', 'bold', 'FontSize', 12)

